﻿var tagID='TopicStatusID_SOmeUniqueValue';	//this is the unique tag id for the tag so that we can find that out.
main();

function main()
{
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		var status = topic.status;
		var statusText = GetStatusText(status);
		//sthis is the topic status
		//we need update the topic now.
		UpdateTopic(topic,statusText);
	}
}

function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function UpdateTopic(topic,statusText)
{
	var filepath = topic.path;
	var msg = 'Updating Topic '+topic.name+' with new status Msg ------>>'+statusText +'\n';
	outputMsg(msg);
	//this is to get the token manager for the topic specified.
	var tokenmgr = RoboHelp.getTokenManager(filepath);
	var bTokenPresent = false;

	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				//check if it is TAg type and has id as 
				if(token.tokenType == RoboHelp.TokenType.TOKENTAG )
				{
					if(token.tagType == RoboHelp.TagType.TAGPARAGRAPH)
					{
						//this is a p tag and we have to check if it has the ID we have specified
						var id = token.getAttribute('id');
						if(id==tagID)
						{
							//we found the tag we have added earlier so update the text only.
							var textToken = token.next;
							textToken.update(statusText);
							bTokenPresent = true;
						}
					}
					
					
					//check for body tag as well
					if(IsEndBodyTag(token) && !bTokenPresent)
					{
						//check that it is end tag
						//we need to add a new tag now
						var newTag = '<p id=\"'+tagID+'\" >'+statusText+'</p>';
						token.insertText(newTag,false);
					}
				}
				token = token.next;
			}
		}
	}
		
	tokenmgr.save();
	outputMsg('Updating Done for File ------>>'+filepath+'\n');
}

function IsEndBodyTag(token)
{
	var bRetVal = false;
	var tokenName = token.name;
	if(tokenName.toLowerCase() == '</body>')
		bRetVal = true;
	return bRetVal;
}

function GetStatusText(status)
{
	var retVal='';
	switch(status)
	{
		case RoboHelp.Status.COMPLETE:
		retVal = 'Topic  Complete';
		break;
		case RoboHelp.Status.READYFORREVIEW:
		retVal = 'Topic  ready for review';
		break;
		case RoboHelp.Status.INPROGRESS :
		retVal = 'Topic  in Progress';
		break;
	}
	return retVal;
}